<?php

namespace App\Http\Controllers;

use App\Models\Card;
use App\Models\Invitation;
use App\Models\CardPledge;
use App\Models\CardSetting;
use App\Models\Pledge;
use App\Models\Member;
use Illuminate\Http\Request;
use Spatie\Browsershot\Browsershot;
use Haruncpi\LaravelIdGenerator\IdGenerator;
use Illuminate\Support\Str;
// use Kreait\Firebase\Contract\Database;
use  Kreait\Firebase\Database;
// use Kreait\Firebase;
// use Kreait\Firebase\Factory;

class CardController extends Controller
{

    public function __construct(Database $database)
    {
        $this->database = $database;
        // $this->database = FirebaseService::connect();
        $this->invitationtable ='invitation';
        $this->tablecard = 'card';
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function add($invitation_id)
    {
        $member= Member::all();
        $invitation = Invitation::findOrFail($invitation_id);     
        $show=$invitation->setRelation('cards', $invitation->cards()->orderBy('id', 'desc')->get());
        return view('cards.add')->withInvitation($invitation)->withMember($member)->withShow($show); 
    }

    
    public function add_child($card_id)
    {
        $member= Member::all();
        $card = Card::findOrFail($card_id);   
        $invitation = Invitation::findOrFail($card->invitation_id);     
        $show=$invitation->setRelation('cards', $invitation->cards()->where('member_id',$card->member_id)->where('parent','child')->orderBy('id', 'desc')->limit(5)->get());
        return view('cards.add_child')->withInvitation($invitation)->withMember($card->member)->withShow($show); 
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated=$request->validate([
            'name' => 'required',
            'phone' => 'required',
            'type' => 'required',
            'invitation_id' => 'required',
        ]);
        $code = random_int(1000, 9999);

        // if($validated['type']=="Single"){$action=1;}elseif($validated['type']=="Double"){$action=2;}
        
        // $invitation = Invitation::findOrFail($validated['invitation_id']);
        // $cards=Card::create([
        //     'code' =>  $code,
        //     'card' =>  $invitation->reg.$code,
        //     'name' =>  $validated['name'],
        //     'phone' =>  $validated['phone'],
        //     'type' =>  $validated['type'],
        //     'sms' =>  '0',
        //     'image' =>  '0',
        //     'status' =>  '0',
        //     'action' =>  $action,
        //     'invitation_id' =>  $validated['invitation_id'],
        //       ]
        // );
      
        // $key= $invitation->reg;

        // // $postRef = $this->database->getReference($this->tablecard)->getChild($cards->card)->set($cards);

        // $invitation->increment('card',1);
        // $invitation->increment('invited',$action);
        // // $postData = [
        // //     'card' => $invitation->card,
        // //     'invited' => $invitation->invited,
        // // ];

        // // $this->database->getReference($this->invitation.'/'.$key)->update($postData);
        
        // return redirect()->back()->with('success', 'Information has Successful Saved ');
    // }
}

public function storecard(Request $request)
    {

        $validated=$request->validate([
            'type' => 'required',
            'pledge' => 'required',
            'invitation_id' => 'required',
        ]);
         
        $icode = random_int(1000, 9999);
    
        $first= substr($icode, 0, 2);
        $end = substr($icode, 2, 4);
        $fmod= $first%7;
        $emod= $end%3;
        $mod=$fmod+$emod;
        $code=$first.$mod.$end;
        $invitation = Invitation::findOrFail($validated['invitation_id']);

        $randomString = Str::upper(Str::random(4));
        // dd($randomString);
        if($validated['type']=="Single"){$action=1;}elseif($validated['type']=="Double"){$action=2;}
        
        if($validated['pledge']=='direct'){
            $validate=$request->validate([
                'pledge_id' => 'required',
            ]);
        $pledge = Pledge::findOrFail($validate['pledge_id']);
        $cards=Card::create([
            'code' =>  $code,
            'b_code' =>  $randomString,
            'card' =>  $invitation->reg.$code,
            'name' =>  $pledge->member->name,
            'pledge'=> $validated['pledge'],
            'parent'=> 'parent',
            'type' =>  $validated['type'],
            'call' =>  '0',
            'sms' =>  '0',
            'image' =>  '0',
            'status' =>  '9',
            'action' =>  $action,
            'member_id' =>  $pledge->member->id,
            'invitation_id' =>  $validated['invitation_id'],
              ]
        );
        $cardpledge = CardPledge::create([
        'card_id'=> $cards->id,
        'pledge_id' => $pledge->id,
        ]);
        $pledge->increment('card',1);
        }elseif($validated['pledge']=='indirect'){
            $validate=$request->validate([
                'parent' => 'required',
                'name' => 'required',
                'phone' => 'required',
            ]);
            if($validate['parent']=='parent'){
            $prefix= 'WI-'.date('dmy').'-';
            $id = IdGenerator::generate(['table' => 'members','field'=>'reg',  'prefix' => $prefix, 'length' => 15, 'reset_on_prefix_change' => true]);
            
            $member= Member::create([
                'reg' =>  $id,
                'name' =>  $validate['name'],
                'phone' =>  $validate['phone'],
                'extra_phone' => $request->extra_phone,
                  ]
            );
            $name = $member->name;
        }elseif($validate['parent']=='child'){
            $validat=$request->validate([
                'member_id' => 'required',
            ]);
            $member = Member::findOrFail($validat['member_id']); 
            $name = $validate['name'];

        }
            $cards=Card::create([
                'code' =>  $code,
                'b_code' =>  $randomString,
                'card' =>  $invitation->reg.$code,
                'name' =>  $name,
                'pledge'=> $validated['pledge'],
                'parent'=> $validate['parent'],
                'type' =>  $validated['type'],
                'call' =>  '0',
                'sms' =>  '0',
                'image' =>  '0',
                'status' =>  '9',
                'action' =>  $action,
                'member_id' =>  $member->id,
                'invitation_id' =>  $validated['invitation_id'],
                  ]
            );
        }

        
        $key= $invitation->reg;

        // $postRef = $this->database->getReference($this->tablecard)->getChild($cards->card)->set($cards);

        $invitation->increment('card',1);
        $invitation->increment('invited',$action);
        // $postData = [
        //     'card' => $invitation->card,
        //     'invited' => $invitation->invited,
        // ];

        // $this->database->getReference($this->invitation.'/'.$key)->update($postData);
        
        return redirect()->back()->with('success', 'Information has Successful Saved ');
 
        }
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Card  $card
     * @return \Illuminate\Http\Response
     */
    public function show($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);
        $shows=$show->setRelation('cards', $show->cards()->where('status','4')->orderBy('id', 'desc')->paginate(20));
        return view('cards.show')->withShows($shows)->withShow($show);
    }

    public function show_online($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);

        $reference = $this->database->getReference($this->tablecard)
        ->orderByChild('invitation_id')->equalTo($show->reg)->getValue();

        $shows= $this->database->getReference($this->invitationtable)
        ->orderByChild('reg')->equalTo($show->reg)
        ->limitToFirst(1)
        ->getValue();
        
        return view('cards.show_online')->withShows($shows)->withShow($show)->withReference($reference);
    
    }

    public function show_active($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);
        $shows=$show->setRelation('cards', $show->cards()->where('status','3')->orderBy('id', 'desc')->paginate(20));
        return view('cards.show_active')->withShows($shows)->withShow($show);
    }

    public function show_call($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);
        $shows=$show->setRelation('cards', $show->cards()->where('status','2')->orderBy('id', 'desc')->paginate(20));
        return view('cards.show_call')->withShows($shows)->withShow($show);
    }
    
    public function show_thanks($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);
        $shows=$show->setRelation('cards', $show->cards()->where('status','9')->orderBy('id', 'desc')->paginate(20));
        return view('cards.show_thanks')->withShows($shows)->withShow($show);
    }
    public function show_sms($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);
        $shows=$show->setRelation('cards', $show->cards()->where('status','0')->orderBy('id', 'desc')->paginate(20));
        return view('cards.show_sms')->withShows($shows)->withShow($show);
    }
    
    public function show_image($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);
        $shows=$show->setRelation('cards', $show->cards()->where('status','1')->orderBy('id', 'desc')->paginate(20));
        return view('cards.show_image')->withShows($shows)->withShow($show);
    }

    public function show_request($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledge', $invitation->pledge()->where('request','1')->where('card','0')->where('action','2')->where('action','2')->orderBy('id', 'desc')->paginate(20));
      
        return view('cards.show_request')->withInvitation($invitation)->withShow($show);
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Card  $card
     * @return \Illuminate\Http\Response
     */
    public function edit($card_id)
    {
        $card = Card::findOrFail($card_id);
        return view('cards.edit')->withCard($card);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Card  $card
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$card)
    {
        $validated=$request->validate([
            'name' => 'required',
            'phone' => 'required',
            'type' => 'required',
            'invitation_id' => 'required',
        ]);

        $invitation = Invitation::findOrFail($validated['invitation_id']);
        if($validated['type']=="Single"){$action=1;}elseif($validated['type']=="Double"){$action=2;}

             $update = Card::findOrFail($card);
             $invitation->decrement('invited',$update->action);

             $update_member = Member::findOrFail($update->member_id);

             $update_member->fill(
                [
                    'name' =>  $validated['name'],
                    'phone' =>  $validated['phone'],
                      ])->save();

             $update->fill(
                [
                    'name' =>  $validated['name'],
                    'type' =>  $validated['type'],
                    'action' =>  $action,
                      ])->save();
             $invitation->increment('invited',$action);
             return redirect()->back()->with('success', 'Successfully Update');
            //  return redirect()->route('invitationn.show',$invitation->id)->with('success', 'Successfully Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Card  $card
     * @return \Illuminate\Http\Response
     */
    public function delete($card)
    {
        $delete = Card::findOrFail($card);
        $invitation = Invitation::findOrFail($delete->invitation_id);
        $invitation->decrement('card',1);
        $invitation->decrement('invited',$delete->action);
        $delete->delete();
        return redirect()->back()->with('success', 'Successfully Deleted');
    }

    public function print($card)
    {
    $show = Card::findOrFail($card);
    // return view('make.card')->withShow($show);
    return view('print.card')->withShow($show);
    }

    public function make($card)
    {
      
    $update = Card::findOrFail($card);
    $pathToImage="card/".$update->name.".png";
    Browsershot::url(route('cards.shot',$card))->fullPage()->save($pathToImage);
    $update->fill(['image' =>  '1'])->save();  
    return redirect()->back()->with('success', 'Information has Successful Image');
    // return view('print.card')->withShow($show);
    }

    public function printall($card)
    {
    $show = Invitation::findOrFail($card);
    return view('print.all')->withShow($show);
    }
    public function image(Request $request,$card)
    {
        $validated=$request->validate([
            'invitation_id' => 'required',
        ]);
        $invitation = Invitation::findOrFail($validated['invitation_id']);

        $update = Card::findOrFail($card);
     
        // $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, 'https://messages-sandbox.nexmo.com/v1/messages');
        // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        // curl_setopt($ch, CURLOPT_HTTPHEADER, [
        //     'Content-Type: application/json',
        //     'Accept: application/json',
        // ]);
        // curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        // curl_setopt($ch, CURLOPT_USERPWD, '5cd7707c:AWVPFFpDf2kHpK7k');
        // curl_setopt($ch, CURLOPT_POSTFIELDS, "{\n    \"from\": \"14157386102\",\n  
        //       \"to\": \"255653524490\",\n    \"message_type\": \"image\",\n 
        //        \"image\": {\n    \"link\": \"HTML::image(card/.\$update->card..png)\",\n  }\n  
        //          \"channel\": \"whatsapp\"\n  }");
        
        // $response = curl_exec($ch);
        // dd($response);
        // curl_close($ch);

        // HTML::image('imgs/picture.jpg') 
    

        $update->fill(['status'=>'2','image' =>  '2'])->save();
        
        return redirect()->back()->with('success', 'Information has Successful Saved ');
    }

    public function show_remind($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $template= CardSetting::where('name','send_reminder')->where('invitation_id',$invitation->id)->first();
        // dd( $template);
        $show=$invitation->setRelation('cards', $invitation->cards()->where('parent','parent')->where('sms','1')->where('status','4')->orderBy('id', 'desc')->get());
        return view('cards.show_remind')->withInvitation($invitation)->withShow($show)->withTemplate($template);
    }
    public function show_thank($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $template= CardSetting::where('name','send_thanks')->where('invitation_id',$invitation->id)->first();
        // dd( $template);
        $show=$invitation->setRelation('cards', $invitation->cards()->where('parent','parent')->where('sms','1')->where('status','4')->orderBy('id', 'desc')->get());
        return view('cards.show_thank')->withInvitation($invitation)->withShow($show)->withTemplate($template);
    }


    public function sms(Request $request,$card)
    {
        $validated=$request->validate([
            'invitation_id' => 'required',
            'sms' => 'required',
            'status' => 'required',

        ]);

        $invitation = Invitation::findOrFail($validated['invitation_id']);
        $update = Card::findOrFail($card);
        $params = [
            'from' => 'COTES TECH',
            'to' => $update->member->phone,
            // 'to' => '255653524490',
            'text' => $validated['sms'],
            'reference' => $update->reg,
        ];
        // dd($validated['sms']);
        if($validated['status']=='yes'){
$data = json_encode($params);
$response = $this->sms_setting($data);
$result = json_decode($response);
// dd($result);
// $result = json_decode($result1);
if($result->messages[0]->status->name=="PENDING_ENROUTE"){   
 $update->fill(['status'=>'1','sms' =>  '1'])->save();
  return redirect()->back()->with('success', 'Information has Successful Saved ');
}else{
    dd($result);
    return redirect()->back()->with('error', 'Information has UnSuccessful Saved ');
}
        }elseif($validated['status']=='no'){
            $update->fill(['status'=>'1'])->save();
            return redirect()->back()->with('success', 'Information has Successful Saved ');  
        }
    }

    public function sms_thanks(Request $request,$card)
    {
        $validated=$request->validate([
            'invitation_id' => 'required',
            'sms' => 'required',
            'status' => 'required',

        ]);

        $invitation = Invitation::findOrFail($validated['invitation_id']);
        $update = Card::findOrFail($card);
        $params = [
            'from' => 'COTES TECH',
            'to' => $update->member->phone,
            // 'to' => '255653524490',
            // 'to' => '255788777777',
            'text' => $validated['sms'],
            'reference' => $update->reg,
        ];
        // dd($validated['sms']);
        if($validated['status']=='yes'){
$data = json_encode($params);
$response = $this->sms_setting($data);
$result = json_decode($response);
// dd($result);
// $result = json_decode($result1);
if($result->messages[0]->status->name=="PENDING_ENROUTE"){   
 $update->fill(['status'=>'0','sms' =>  '5'])->save();
  return redirect()->back()->with('success', 'Information has Successful Saved ');
}else{
    dd($result);
    return redirect()->back()->with('error', 'Information has UnSuccessful Saved ');
}
        }elseif($validated['status']=='no'){
            $update->fill(['status'=>'0'])->save();
            return redirect()->back()->with('success', 'Information has Successful Saved ');  
        }
    }


    public function call(Request $request,$card)
    {
        $validated=$request->validate([
            'call' => 'required',
        ]);

        $update = Card::findOrFail($card); 
        if($validated['call']=='Verify'){
            $update->fill(['status'=>'3','call' => $validated['call']])->save();
        }else{
            $update->fill(['call' => $validated['call']])->save(); 
        }

        return redirect()->back()->with('success', 'Information has Successful Saved ');
    } 


    public function activatecard($card)
    {
        $kad = Card::findOrFail($card);
        $invitation = Invitation::findOrFail($kad->invitation_id);

        $key= $invitation->reg;
        $cards=[
            'code' =>  $kad->code,
            'b_code' =>  $kad->b_code,
            'card' =>  $kad->card,
            'reg' =>  $invitation->reg,
            'name' =>  $kad->name,
            'phone' =>  $kad->member->phone,
            'type' =>  $kad->type,
            'status' =>  1,
            'action' =>  $kad->action,
            'invitation_id' =>  $invitation->reg,
              ];
              
     
        $invitation->increment('livecard',1);
        $invitation->increment('liveinvited',$kad->action);
        
        $postData = [
            'card' => $invitation->livecard,
            'invited' => $invitation->liveinvited,
        ];
        $postRef = $this->database->getReference($this->tablecard)->getChild($kad->card)->set($cards);
        $this->database->getReference($this->invitationtable.'/'.$key)->update($postData);

           $kad->fill(['status' =>  '4'])->save();
        return redirect()->back()->with('success', 'Information has Successful Saved ');
    }

    public function active_report($invitation)
    {
        $show = Invitation::findOrFail($invitation);
        $show->setRelation('cards', $show->cards()->orderBy('type', 'asc')->orderBy('name', 'asc')->get());
        return view('card_reports.active')->withShow($show);
    }

    public function thanks_report($invitation)
    {
        $show = Invitation::findOrFail($invitation);
        $show->setRelation('cards', $show->cards()->orderBy('type', 'asc')->orderBy('name', 'asc')->get());
        return view('card_reports.thanks')->withShow($show);
    }

        public function online_report($invitation_id)
    {
       $show = Invitation::findOrFail($invitation_id);

        $reference = $this->database->getReference($this->tablecard)
        ->orderByChild('invitation_id')->equalTo($show->reg)->getValue();

        $shows= $this->database->getReference($this->invitationtable)
        ->orderByChild('reg')->equalTo($show->reg)
        ->limitToFirst(1)
        ->getValue();
        
        return view('card_reports.online')->withShows($shows)->withShow($show)->withReference($reference);
    }

    public function sms_setting($data){
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/single',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => array(
          'Authorization: Basic Y2FpbGFuOmNhaWxhbkAyMQ==',
          'Content-Type: application/json',
          'Accept: application/json'
        ),
      ));
  
      $response = curl_exec($curl);
      curl_close($curl);
      return $response;
    }
    public function card_remind(Request $request)
    {
        $validated=$request->validate([
            'invitation_id' => 'required',
        ]);
        $invitation = Invitation::findOrFail($validated['invitation_id']);
        $template= CardSetting::where('name','send_reminder')->where('invitation_id',$invitation->id)->first();
        // dd( $template);
        $show=$invitation->setRelation('cards', $invitation->cards()->where('parent','parent')->where('sms','1')->where('status','3')->orwhere('status','2')->orderBy('id', 'desc')->get());
    
        $result = $this->sms_remind($template,$invitation,$show);

    }
    public function sms_remind($template,$invitation,$show)
    {
    
    $param = [];
    foreach($show->cards as $list) {
        $param[] = [
        'from' => 'COTES TECH',
        'to' =>  $list->member->phone,
        'text' => view('sms.remind_card',compact('template', 'list'))->render()
        ];
    }

$data = json_encode([ 'messages' => $param,
'reference' => $invitation->id]);

    // dd($params);
      $curl = curl_init();
      
      curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/multi',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => $data,
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic Y2FpbGFuOmNhaWxhbkAyMQ==',
        'Content-Type: application/json',
        'Accept: application/json'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $result = json_decode($response);
    dd($result);
    }

    public function card_thank(Request $request)
    {
        $validated=$request->validate([
            'invitation_id' => 'required',
        ]);
        $invitation = Invitation::findOrFail($validated['invitation_id']);
        $template= CardSetting::where('name','send_thanks')->where('invitation_id',$invitation->id)->first();
        // dd( $template);
        $show=$invitation->setRelation('cards', $invitation->cards()->where('parent','parent')->where('sms','1')->where('status','4')->orderBy('id', 'desc')->get());
    
        $result = $this->sms_thank($template,$invitation,$show);

    }
    public function sms_thank($template,$invitation,$show)
    {
    
    $param = [];
    foreach($show->cards as $list) {
        $param[] = [
        'from' => 'COTES TECH',
        'to' =>  $list->member->phone,
        'text' => view('sms.thank_card',compact('template', 'list'))->render()
        ];
    }

$data = json_encode([ 'messages' => $param,
'reference' => $invitation->id]);

    // dd($params);
      $curl = curl_init();
      
      curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/multi',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => $data,
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic Y2FpbGFuOmNhaWxhbkAyMQ==',
        'Content-Type: application/json',
        'Accept: application/json'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $result = json_decode($response);
    dd($result);
    }
}
