<?php

namespace App\Http\Controllers;
use App\Models\Invitation;
use App\Models\CardSetting;
use Illuminate\Http\Request;

class CardSettingController extends Controller
{
    public function __construct(){
   
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($invitation_id)
    {
        $show = Invitation::findOrFail($invitation_id);

        // $reference = $this->database->getReference($this->tablename)
        // ->orderByChild('invitation_id')->equalTo($invitation)->getValue();

        // $shows= $this->database->getReference($this->invitationtable)
        // ->orderByChild('id')->equalTo($invitation)
        // ->limitToFirst(1)
        // ->getValue();
        
        // dd($shows);
        // $shows=$show->setRelation('cards', $show->cards()->where('status','0')->orderBy('id', 'desc')->paginate(20));
        $card = $show->card_setting()->where('name','send_invitation')->first();
        $thanks = $show->card_setting()->where('name','send_thanks')->first();
        $reminder = $show->card_setting()->where('name','send_reminder')->first();
        return view('card_settings.show')->withShow($show)->withCard($card)->withThanks($thanks)->withReminder($reminder);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validated=$request->validate([
            'status' => 'required',
            'text' => 'required',
        ]);
        $card = CardSetting::findOrFail($id);
        $card->fill([
            'status' => $validated['status'],
            'text' => $validated['text']
            ])->save();
            return redirect()->back()->with('success', 'Information has Successful Saved ');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
