<?php

namespace App\Http\Controllers;
use App\Models\package;
use App\Models\Agent;
use App\Models\Invitation;
use App\Models\PledgeSetting;
use App\Models\CardSetting;
use Illuminate\Http\Request;
// use Kreait\Firebase\Contract\Database;
// use Kreait\Laravel\Firebase\Facades\Firebase;
use  Kreait\Firebase\Database;
use Haruncpi\LaravelIdGenerator\IdGenerator;

class InvitationController extends Controller
{
    public function __construct(Database $database){
        $this->database = $database;
        // $this->database = FirebaseService::connect();
        $this->tablename = 'card';
        $this->invitationtable = 'invitation';
        $this->verificationtable = 'verifications';
        $this->middleware('auth');
    }
       /**
     * Create a new controller instance.
     *
     * @return void
     */
    // public function __construct()
    // {
        
    // }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $show = Invitation::paginate(10);
        return view('invitations.index',compact('show'));
    }

    /**
     * Show the forms for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $agent = Agent::where('action','1')->get();
        $package = Package::where('action','1')->get();
        return view('invitations.create')->withAgent($agent)->withPackage($package);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated=$request->validate([
            'name' => 'required',
            'phone' => 'required',
            'details' => 'required',
            'event' => 'required',
            'package_id' => 'required',
            'agent_id' => 'required',
            'action' => 'required',
            'pledge' => 'required',
            'inv_cards' => 'required',
            'allow_sms' => 'required',
        ]);
        // dd($validated);
        $prefix= 'E-'.date('dmy').'-';
        $id = IdGenerator::generate(['table' => 'invitations','field'=>'reg',  'prefix' => $prefix, 'length' => 12, 'reset_on_prefix_change' => true]);
        $verification = mt_rand( 100000, 999999 );
        $invitation= Invitation::create([
            'reg' =>  $id,
            'name' =>  $validated['name'],
            'phone' =>  $validated['phone'],
            'details' =>  $validated['details'],
            'event' =>  $validated['event'],
            'card' =>  "0",
            'livecard' =>  "0",
            'invited' =>  "0",
            'liveinvited' =>  "0",
            'arrived' =>  "0",
            'allowed' =>  "0",
            'single' =>  0,
            'double' =>  0,
            'allow_sms' =>  $validated['allow_sms'],
            'pledge' =>  $validated['pledge'],
            'inv_card' =>  $validated['inv_cards'],
            'verification' => $verification,
            'action' =>  $validated['action'],
            'package_id' =>  $validated['package_id'],
            'agent_id' =>  $validated['agent_id'],
              ]
        );
        if($validated['pledge']==1){
            $array = [
                [
                    'name' =>  'send_request',
                    'status' =>  0,
                    'text' => 'WIKAD TANZANIA',
                    'invitation_id' =>  $invitation->id,
                ],[
                    'name' =>  'send_pledge',
                    'text' => 'WIKAD TANZANIA',
                    'status' =>  0,
                    'invitation_id' =>  $invitation->id,
                ],[
                    'name' =>  'send_payment',
                    'text' => 'WIKAD TANZANIA',
                    'status' =>  0,
                    'invitation_id' =>  $invitation->id,
                ],[
                        'name' =>  'send_finish',
                        'text' => 'WIKAD TANZANIA',
                        'status' =>  0,
                        'invitation_id' =>  $invitation->id,
                ],[
                    'name' =>  'send_addition',
                    'text' => 'WIKAD TANZANIA',
                    'status' =>  0,
                    'invitation_id' =>  $invitation->id,
                ],[
                    'name' =>  'remind_pledge',
                    'text' => 'WIKAD TANZANIA',
                    'status' =>  0,
                    'invitation_id' =>  $invitation->id,
                      ]
            ];
            foreach ($array as $value) {
                PledgeSetting::create($value);
            }
        }
        if($validated['inv_cards']==1){
            $array2 = [
                [
                    'name' =>  'send_invitation',
                    'status' =>  0,
                    'text' => 'WIKAD TANZANIA',
                    'invitation_id' =>  $invitation->id,
                ],[
                    'name' =>  'send_thanks',
                    'text' => 'WIKAD TANZANIA',
                    'status' =>  0,
                    'invitation_id' =>  $invitation->id,
                ],[
                    'name' =>  'send_reminder',
                    'text' => 'WIKAD TANZANIA',
                    'status' =>  0,
                    'invitation_id' =>  $invitation->id,
                ]
            ];
            foreach ($array2 as $value2) {
                CardSetting::create($value2);
            }}
        return redirect()->route('invitationn.show',$invitation->id)->with('success', 'Information has Successful Saved ');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Invitation  $invitation
     * @return \Illuminate\Http\Response
     */
    public function show($invitation)
    {
        $show = Invitation::findOrFail($invitation);

        // $reference = $this->database->getReference($this->tablename)
        // ->orderByChild('invitation_id')->equalTo($invitation)->getValue();

        // $shows= $this->database->getReference($this->invitationtable)
        // ->orderByChild('id')->equalTo($invitation)
        // ->limitToFirst(1)
        // ->getValue();
        
        // dd($shows);
        $shows=$show->setRelation('cards', $show->cards()->where('status','0')->orderBy('id', 'desc')->paginate(20));
        return view('invitations.show')->withShows($shows)->withShow($show);
    }


    public function liveshow($invitation)
    {
        $show = Invitation::findOrFail($invitation);

        $reference = $this->database->getReference($this->tablename)
        ->orderByChild('invitation_id')->getValue();

        $shows= $this->database->getReference($this->invitationtable)
        ->orderByChild('reg')->equalTo($show->reg)
        ->limitToFirst(1)
        ->getValue();
        
        // dd($shows);
        // $shows=$show->setRelation('cards', $show->cards()->orderBy('id', 'desc')->paginate(10));
        return view('invitations.liveshow')->withShows($shows)->withShow($show)->withReference($reference);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Invitation  $invitation
     * @return \Illuminate\Http\Response
     */
    public function edit($invitation_id)
    {        
        $invitation = Invitation::findOrFail($invitation_id);
        $agent = Agent::where('action','1')->get();
        $package = Package::where('action','1')->get();
        return view('invitations.edit')->withAgent($agent)->withPackage($package)->withInvitation($invitation);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Invitation  $invitation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Invitation $invitation)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Invitation  $invitation
     * @return \Illuminate\Http\Response
     */
    public function destroy(Invitation $invitation)
    {
        //
    }
    public function report($invitation)
    {
        $show = Invitation::findOrFail($invitation);
        $show->setRelation('cards', $show->cards()->where('status', '0')->orderBy('type', 'asc')->orderBy('name', 'asc')->get());
        return view('invitations.report')->withShow($show);
    }
    public function activateinvitation($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $invitations=[
            'action' =>  $invitation->code,
            'allowed' =>  0,
            'arrived' =>  0,
            'card' =>  0,
            'details' =>  $invitation->details,
            'event' => date('d-m-Y', strtotime($invitation->event)) , 
            'invited' =>  0,
            'name' =>  $invitation->name,
            'package' =>  $invitation->package->name,
            'reg' =>  $invitation->reg,
              ];
               $verification=[
                'ver' => $invitation->verification,
                'uuid' => $invitation->reg,
                'expire' => date('Y-m-d 23:59', strtotime($invitation->event)),
                'expire' => date('Y-m-d 23:59', strtotime($invitation->event)),
               ];

        $postRef = $this->database->getReference($this->invitationtable )->getChild($invitation->reg)->set($invitations);
        $ver = $this->database->getReference($this->verificationtable )->getChild($invitation->verification)->set($verification);
        $invitation->fill(['action' =>  '2'])->save();
        return redirect()->back()->with('success', 'Information has Successful Saved ');
    }

}
