<?php

namespace App\Http\Controllers;
use Auth;
use App\Models\PledgeSetting;
use App\Models\Pledge;
use App\Models\Member;
use App\Models\Invitation;
use App\Models\PledgeTransaction;
use Illuminate\Http\Request;
use Haruncpi\LaravelIdGenerator\IdGenerator;

class PledgeController extends Controller
{
    public function __construct(){
        // $this->database = $database;
        // // $this->database = FirebaseService::connect();
        // $this->tablename = 'card';
        // $this->invitationtable = 'invitation';
        // $this->verificationtable = 'verifications';
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validated=$request->validate([
            'name' => 'required',
            'phone' => 'required',
            'amount' => 'required',
            'invitation_id' => 'required',
            'request' => 'required',
        ]);
        // dd($validated);
        $prefix= 'WI-'.date('dmy').'-';
        $id = IdGenerator::generate(['table' => 'members','field'=>'reg',  'prefix' => $prefix, 'length' => 15, 'reset_on_prefix_change' => true]);
        
        $member= Member::create([
            'reg' =>  $id,
            'name' =>  $validated['name'],
            'phone' =>  $validated['phone'],
            'extra_phone' => $request->extra_phone,
              ]
        );
        // $checkpledge= Pledge:
        $pledge= Pledge::create([
            'amount' =>  $validated['amount'],
            'invitation_id' =>  $validated['invitation_id'],
            'request' =>  $validated['request'],
            'member_id' => $member->id,
            'paid' => 0,
            'addition' => 0,
            'card' => 0,
            'status' => 'active',
            'action' => 0,
              ]
        );
        return redirect()->back()->with('success', 'Information has Successful Saved ');
    
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Pledge  $pledge
     * @return \Illuminate\Http\Response
     */
    public function show($invitation_id)
    {
        $member= Member::all();
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','active')->where('action','1')->orderBy('id', 'desc')->paginate(20));
      
        return view('pledge.show')->withInvitation($invitation)->withShow($show)->withMember($member);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Pledge  $pledge
     * @return \Illuminate\Http\Response
     */
    public function edit($pledge_id)
    {
        $pledge = Pledge::findOrFail($pledge_id);
        $invitation = Invitation::findOrFail($pledge->invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->orderBy('id', 'desc')->limit(5)->get()); 
        return view('pledge.edit')->withPledge($pledge)->withShow($show)->withInvitation($invitation);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Pledge  $pledge
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $pledge)
    {
        $validated=$request->validate([
            'name' => 'required',
            'phone' => 'required',
            'amount' => 'required',
            'invitation_id' => 'required',
            'request' => 'required',
        ]);
             $update = Pledge::findOrFail($pledge);

             $update_member = Member::findOrFail($update->member_id);

             $update_member->fill(
                [
                    'name' =>  $validated['name'],
                    'phone' =>  $validated['phone'],
                    'extra_phone' => $request->extra_phone,
                      ])->save();

             $update->fill(
                [
                    'amount' =>  $validated['amount'],
                    'invitation_id' =>  $validated['invitation_id'],
                    'request' =>  $validated['request'],
                      ])->save();

             return redirect()->back()->with('success', 'Successfully Deleted');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Pledge  $pledge
     * @return \Illuminate\Http\Response
     */
    public function destroy(Pledge $pledge)
    {
        //
    }


    public function add($invitation_id)
    {
        $member= Member::all();
        $invitation = Invitation::findOrFail($invitation_id);     
        $show=$invitation->setRelation('pledges', $invitation->pledges()->orderBy('id', 'desc')->limit(5)->get()); 
        return view('pledge.add')->withInvitation($invitation)->withMember($member)->withShow($show); 
    }


    public function show_request($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','0')->where('status','active')->orderBy('id', 'desc')->get());
      
        return view('pledge.show_request')->withInvitation($invitation)->withShow($show);
    }


    public function show_waiting($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','active')->where('action','0')->orderBy('id', 'desc')->get());
      
        return view('pledge.show_waiting')->withInvitation($invitation)->withShow($show);
    }
    public function show_finish($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','finish')->where('action','1')->orderBy('id', 'desc')->get());
      
        return view('pledge.show_finish')->withInvitation($invitation)->withShow($show);
    }
    public function show_card($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','finish')->where('action','1')->orderBy('id', 'desc')->get());
      
        return view('pledge.show_card')->withInvitation($invitation)->withShow($show);
    }

    public function show_remind($invitation_id)
    {
        $invitation = Invitation::findOrFail($invitation_id);
        $template= PledgeSetting::where('name','remind_pedge')->where('invitation_id',$invitation->id)->first();
        // dd( $template);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','active')->where('action','1')->orderBy('id', 'desc')->paginate(5));
        return view('pledge.show_remind')->withInvitation($invitation)->withShow($show)->withTemplate($template);
    }


    public function card_request($pledge_id)
    {
        $pledge = Pledge::findOrFail($pledge_id);
        $pledge->fill(['action' =>  '2'])->save();
        return redirect()->back()->with('success', 'Information has Successful Saved ');
  

    }

    public function send_request($pledge_id)
    {
        $pledge = Pledge::findOrFail($pledge_id);
       
        $template= PledgeSetting::where('name','send_request')->where('invitation_id',$pledge->invitation_id)->first();
        $result = $this->sms_set($template,$pledge);
        // dd($result);
    if($result->messages[0]->status->name=="PENDING_ENROUTE"){   
        $pledge->fill(['request' =>  '1'])->save();
        return redirect()->back()->with('success', 'Information has Successful Saved ');
        }else{
            dd($result);
        }

    }


    public function pledge_remind(Request $request)
    {
        $validated=$request->validate([
            'invitation_id' => 'required',
        ]);
        $invitation = Invitation::findOrFail($validated['invitation_id']);
        $template= PledgeSetting::where('name','remind_pedge')->where('invitation_id',$invitation->id)->first();
        // dd( $template);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','active')->where('action','1')->get());
        $result = $this->sms_remind($template,$invitation,$show);

    }
    

    public function pledge_store(Request $request)
    {
        $validated=$request->validate([
            'amount' => 'required',
            'pledge_id' => 'required',
        ]);
        $pledge = Pledge::findOrFail($validated['pledge_id']);
        $pledge->fill(['amount' => $validated['amount'],'action' =>  '1'])->save();
        $template= PledgeSetting::where('name','send_pedge')->where('invitation_id',$pledge->invitation_id)->first();
        $result = $this->sms_set($template,$pledge);
    if($result->messages[0]->status->name=="PENDING_ENROUTE"){   
       
        return redirect()->back()->with('success', 'Information has Successful Saved ');
        }else{
            dd($result);
        }
       
    }


    public function pledge_pay(Request $request)
    {
        $validated=$request->validate([
            'amount' => 'required',
            'pledge_id' => 'required',
        ]);
        $pledge = Pledge::findOrFail($validated['pledge_id']);
        $transaction= PledgeTransaction::create([
            'amount' =>  $validated['amount'],
            'invitation_id' =>  $pledge->invitation->id,
            'member_id' => $pledge->member->id,
            'pledge_id' => $pledge->id,
            'user_id' => Auth::user()->id,
              ]
        );
        $due= $pledge->amount-$pledge->paid;
        if($due >= $validated['amount']){
        $pledge->increment('paid',$validated['amount']);
        if($pledge->paid==$pledge->amount){
        $pledge->fill(['status' => 'finish'])->save();
        $template= PledgeSetting::where('name','send_finish')->where('invitation_id',$pledge->invitation_id)->first();
        } else{
        $template= PledgeSetting::where('name','send_payment')->where('invitation_id',$pledge->invitation_id)->first();
        }
        }
        else{
        $addition = $validated['amount']-$due;
        $pledge->increment('paid',$due); 
        $pledge->increment('addition',$addition );
        $pledge->fill(['status' => 'finish'])->save();
        $template= PledgeSetting::where('name','send_addition')->where('invitation_id',$pledge->invitation_id)->first();
        }
        $result = $this->sms_pay($template,$pledge,$transaction);
        if($result->messages[0]->status->name=="PENDING_ENROUTE"){   
        return redirect()->back()->with('success', 'Information has Successful Saved ');
        }else{
            dd($result);
        }
    }


    public function report($invitation_id)
    {
        $member= Member::all();
        $invitation = Invitation::findOrFail($invitation_id);
        $show=$invitation->setRelation('pledges', $invitation->pledges()->where('request','1')->where('status','active')->orwhere('status','finish')->where('action','1')->orderBy('id', 'desc')->paginate(20));
      
        return view('pledge.report')->withInvitation($invitation)->withShow($show)->withMember($member);
    }


    public function sms_remind($template,$invitation,$show)
    {
    
    $param = [];
    foreach($show->pledges as $list) {
        $param[] = [
        'from' => 'COTES TECH',
        'to' =>  $list->member->phone,
        'text' => view('sms.remind',compact('template', 'list'))->render()
        ];
    }

$data = json_encode([ 'messages' => $param,
'reference' => $invitation->id]);

    // dd($params);
      $curl = curl_init();
      
      curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/multi',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => $data,
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic Y2FpbGFuOmNhaWxhbkAyMQ==',
        'Content-Type: application/json',
        'Accept: application/json'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $result = json_decode($response);
    dd($result);
    }


    public function sms_set($template,$pledge)
    {
    $viewRender = view('sms.send',compact('template', 'pledge'))->render();
    $params = [
        'from' => 'COTES TECH',
        'to' => $pledge->member->phone,
        'text' => $viewRender,
        'reference' => $pledge->id,
    ];
    $data = json_encode($params);
    $response = $this->sms_setting($data);
    return $result = json_decode($response);
    }


    public function sms_pay($template,$pledge,$transaction)
    {
            $viewRender = view('sms.pay',compact('template', 'pledge','transaction'))->render();
            $params = [
                'from' => 'COTES TECH',
                'to' => $pledge->member->phone,
                'text' => $viewRender,
                'reference' => $pledge->id,
            ];
    $data = json_encode($params);
    $response = $this->sms_setting($data);
    return $result = json_decode($response);
    }

    public function sms_setting($data){
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://messaging-service.co.tz/api/sms/v1/text/single',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => array(
          'Authorization: Basic Y2FpbGFuOmNhaWxhbkAyMQ==',
          'Content-Type: application/json',
          'Accept: application/json'
        ),
      ));
  
      $response = curl_exec($curl);
      curl_close($curl);
      return $response;
    }
}
